/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_769;
import net.minecraft.class_846;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlClientChunkMap;
import qouteall.imm_ptl.core.ducks.IERenderSection;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.miscellaneous.GcMonitor;
import qouteall.q_misc_util.Helper;

@Environment(value=EnvType.CLIENT)
public class ImmPtlViewArea
extends class_769 {
    private final class_846 factory;
    private final Long2ObjectOpenHashMap<Column> columnMap = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Preset> presets = new Long2ObjectOpenHashMap();
    private Preset currentPreset = null;
    public final int minSectionY;
    public final int endSectionY;
    private boolean isAlive = true;

    public static void init() {
        ImmPtlClientChunkMap.clientChunkUnloadSignal.connect(section -> {
            class_769 viewArea;
            class_5321 dimension = section.method_12200().method_27983();
            class_761 worldRenderer = ClientWorldLoader.WORLD_RENDERER_MAP.get(dimension);
            if (worldRenderer != null && (viewArea = ((IEWorldRenderer)worldRenderer).ip_getBuiltChunkStorage()) instanceof ImmPtlViewArea) {
                ImmPtlViewArea immPtlViewArea = (ImmPtlViewArea)viewArea;
                immPtlViewArea.onChunkUnload(section.method_12004().field_9181, section.method_12004().field_9180);
            }
        });
        IPGlobal.POST_CLIENT_TICK_EVENT.register(() -> {
            if (ClientWorldLoader.getIsInitialized()) {
                for (class_638 world : ClientWorldLoader.getClientWorlds()) {
                    class_761 worldRenderer = ClientWorldLoader.getWorldRenderer((class_5321<class_1937>)world.method_27983());
                    class_769 viewArea = ((IEWorldRenderer)worldRenderer).ip_getBuiltChunkStorage();
                    if (!(viewArea instanceof ImmPtlViewArea)) continue;
                    ImmPtlViewArea immPtlViewArea = (ImmPtlViewArea)viewArea;
                    immPtlViewArea.tick();
                }
            }
        });
    }

    public ImmPtlViewArea(class_846 sectionBuilder, class_1937 world, int r, class_761 worldRenderer) {
        super(sectionBuilder, world, r, worldRenderer);
        this.factory = sectionBuilder;
        int cacheSize = this.field_4148 * this.field_4149 * this.field_4147;
        if (IPGlobal.cacheGlBuffer) {
            cacheSize /= 10;
        }
        this.minSectionY = McHelper.getMinSectionY((class_1936)world);
        this.endSectionY = McHelper.getMaxSectionYExclusive((class_1936)world);
    }

    protected void method_3324(class_846 sectionBuilder_1) {
        int num = this.field_4148 * this.field_4149 * this.field_4147;
        this.field_4150 = new class_846.class_851[num];
    }

    public void method_3327() {
        Set<class_846.class_851> allActiveBuiltChunks = this.getAllActiveBuiltChunks();
        allActiveBuiltChunks.forEach(class_846.class_851::method_3659);
        this.columnMap.clear();
        this.presets.clear();
        this.isAlive = false;
    }

    public void method_3330(double playerX, double playerZ) {
        class_310.method_1551().method_16011().method_15396("built_section_storage");
        int cameraBlockX = class_3532.method_15357((double)playerX);
        int cameraBlockZ = class_3532.method_15357((double)playerZ);
        int cameraChunkX = cameraBlockX >> 4;
        int cameraChunkZ = cameraBlockZ >> 4;
        class_1923 cameraChunkPos = new class_1923(cameraChunkX, cameraChunkZ);
        Preset preset = (Preset)this.presets.computeIfAbsent(cameraChunkPos.method_8324(), whatever -> this.createPresetByChunkPos(cameraChunkX, cameraChunkZ));
        preset.lastActiveTime = System.nanoTime();
        this.field_4150 = preset.data;
        this.currentPreset = preset;
        class_310.method_1551().method_16011().method_15407();
    }

    public void method_16040(int cx, int cy, int cz, boolean isImportant) {
        class_846.class_851 builtChunk = this.provideBuiltChunkByChunkPos(cx, cy, cz);
        builtChunk.method_3654(isImportant);
    }

    public class_846.class_851 provideBuiltChunkByChunkPos(int cx, int cy, int cz) {
        Column column = this.provideColumn(class_1923.method_8331((int)cx, (int)cz));
        int offsetChunkY = class_3532.method_15340((int)(cy - McHelper.getMinSectionY((class_1936)this.field_4151)), (int)0, (int)(McHelper.getYSectionNumber((class_1936)this.field_4151) - 1));
        return column.sections[offsetChunkY];
    }

    private Preset createPresetByChunkPos(int sectionX, int sectionZ) {
        class_846.class_851[] sections1 = new class_846.class_851[this.field_4148 * this.field_4149 * this.field_4147];
        for (int cx = 0; cx < this.field_4148; ++cx) {
            int xBlockSize = this.field_4148 * 16;
            int xStart = (sectionX << 4) - xBlockSize / 2;
            int px = xStart + Math.floorMod(cx * 16 - xStart, xBlockSize);
            for (int cz = 0; cz < this.field_4147; ++cz) {
                int zBlockSize = this.field_4147 * 16;
                int zStart = (sectionZ << 4) - zBlockSize / 2;
                int pz = zStart + Math.floorMod(cz * 16 - zStart, zBlockSize);
                Validate.isTrue((px % 16 == 0 ? 1 : 0) != 0);
                Validate.isTrue((pz % 16 == 0 ? 1 : 0) != 0);
                Column column = this.provideColumn(class_1923.method_8331((int)(px >> 4), (int)(pz >> 4)));
                for (int offsetCy = 0; offsetCy < this.field_4149; ++offsetCy) {
                    int index = this.getChunkIndex(cx, offsetCy, cz);
                    sections1[index] = column.sections[offsetCy];
                }
            }
        }
        return new Preset(sections1);
    }

    private void foreachPresetCoveredChunkPoses(int centerChunkX, int centerChunkZ, LongConsumer func) {
        class_846.class_851[] sections1 = new class_846.class_851[this.field_4148 * this.field_4149 * this.field_4147];
        for (int cx = 0; cx < this.field_4148; ++cx) {
            int xBlockSize = this.field_4148 * 16;
            int xStart = (centerChunkX << 4) - xBlockSize / 2;
            int px = xStart + Math.floorMod(cx * 16 - xStart, xBlockSize);
            for (int cz = 0; cz < this.field_4147; ++cz) {
                int zBlockSize = this.field_4147 * 16;
                int zStart = (centerChunkZ << 4) - zBlockSize / 2;
                int pz = zStart + Math.floorMod(cz * 16 - zStart, zBlockSize);
                Validate.isTrue((px % 16 == 0 ? 1 : 0) != 0);
                Validate.isTrue((pz % 16 == 0 ? 1 : 0) != 0);
                long sectionPos = class_1923.method_8331((int)(px >> 4), (int)(pz >> 4));
                func.accept(sectionPos);
            }
        }
    }

    private int getChunkIndex(int x, int y, int z) {
        return (z * this.field_4149 + y) * this.field_4148 + x;
    }

    public Column provideColumn(long sectionPos) {
        return (Column)this.columnMap.computeIfAbsent(sectionPos, this::createColumn);
    }

    private Column createColumn(long sectionPos) {
        class_846.class_851[] array = new class_846.class_851[this.field_4149];
        int sectionX = class_1923.method_8325((long)sectionPos);
        int sectionZ = class_1923.method_8332((long)sectionPos);
        int minY = McHelper.getMinY((class_1936)this.field_4151);
        for (int offsetCY = 0; offsetCY < this.field_4149; ++offsetCY) {
            class_846.class_851 builtChunk;
            class_846 class_8462 = this.factory;
            Objects.requireNonNull(class_8462);
            array[offsetCY] = builtChunk = new class_846.class_851(class_8462, 0, sectionX << 4, (offsetCY << 4) + minY, sectionZ << 4);
        }
        return new Column(array);
    }

    private void tick() {
        if (!this.isAlive) {
            return;
        }
        class_638 worldClient = class_310.method_1551().field_1687;
        if (worldClient != null) {
            if (GcMonitor.isMemoryNotEnough()) {
                if (worldClient.method_8510() % 3L == 0L) {
                    this.purge();
                }
            } else if (worldClient.method_8510() % 213L == 66L) {
                this.purge();
            }
        }
    }

    private void purge() {
        class_310.method_1551().method_16011().method_15396("my_built_section_storage_purge");
        long dropTime = Helper.secondToNano(GcMonitor.isMemoryNotEnough() ? 3.0 : 20.0);
        long currentTime = System.nanoTime();
        this.presets.long2ObjectEntrySet().removeIf(entry -> {
            Preset preset = (Preset)entry.getValue();
            long centerChunkPos = entry.getLongKey();
            boolean shouldDropPreset = this.shouldDropPreset(dropTime, currentTime, preset);
            if (!shouldDropPreset) {
                this.foreachPresetCoveredChunkPoses(class_1923.method_8325((long)centerChunkPos), class_1923.method_8332((long)centerChunkPos), columnChunkPos -> {
                    Column column = (Column)this.columnMap.get(columnChunkPos);
                    column.mark = currentTime;
                });
            }
            return shouldDropPreset;
        });
        long timeThreshold = Helper.secondToNano(5.0);
        ArrayDeque toDelete = new ArrayDeque();
        this.columnMap.long2ObjectEntrySet().removeIf(entry -> {
            boolean shouldRemove;
            Column column = (Column)entry.getValue();
            boolean bl = shouldRemove = currentTime - column.mark > timeThreshold;
            if (shouldRemove) {
                toDelete.addAll(Arrays.asList(column.sections));
            }
            return shouldRemove;
        });
        if (!toDelete.isEmpty()) {
            IPGlobal.PRE_GAME_RENDER_TASK_LIST.addTask(() -> {
                if (toDelete.isEmpty()) {
                    return true;
                }
                for (int num = 0; !toDelete.isEmpty() && num < 100; ++num) {
                    class_846.class_851 builtChunk = (class_846.class_851)toDelete.poll();
                    builtChunk.method_3659();
                }
                return false;
            });
        }
        class_310.method_1551().method_16011().method_15407();
    }

    private boolean shouldDropPreset(long dropTime, long currentTime, Preset preset) {
        if (preset.data == this.field_4150) {
            return false;
        }
        return currentTime - preset.lastActiveTime > dropTime;
    }

    private Set<class_846.class_851> getAllActiveBuiltChunks() {
        HashSet<class_846.class_851> result = new HashSet<class_846.class_851>();
        this.presets.forEach((key, preset) -> result.addAll(Arrays.asList(preset.data)));
        if (this.field_4150 != null) {
            result.addAll(Arrays.asList(this.field_4150));
        }
        result.remove(null);
        return result;
    }

    public int getManagedSectionNum() {
        return this.columnMap.size() * this.field_4149;
    }

    public String getDebugString() {
        return String.format("Built Section Storage Columns:%s", this.columnMap.size());
    }

    public int getRadius() {
        return (this.field_4148 - 1) / 2;
    }

    public boolean isRegionActive(int cxStart, int czStart, int cxEnd, int czEnd) {
        for (int cx = cxStart; cx <= cxEnd; ++cx) {
            for (int cz = czStart; cz <= czEnd; ++cz) {
                if (!this.columnMap.containsKey(class_1923.method_8331((int)cx, (int)cz))) continue;
                return true;
            }
        }
        return false;
    }

    public void onChunkUnload(int sectionX, int sectionZ) {
        long sectionPos = class_1923.method_8331((int)sectionX, (int)sectionZ);
        Column column = (Column)this.columnMap.get(sectionPos);
        if (column != null) {
            for (class_846.class_851 builtChunk : column.sections) {
                ((IERenderSection)builtChunk).portal_fullyReset();
            }
        }
    }

    public class_846.class_851 getSectionFromRawArray(class_2338 sectionOrigin, class_846.class_851[] sections) {
        int i = class_3532.method_48116((int)sectionOrigin.method_10263(), (int)16);
        int j = class_3532.method_48116((int)(sectionOrigin.method_10264() - McHelper.getMinY((class_1936)this.field_4151)), (int)16);
        int k = class_3532.method_48116((int)sectionOrigin.method_10260(), (int)16);
        if (j >= 0 && j < this.field_4149) {
            i = class_3532.method_15387((int)i, (int)this.field_4148);
            k = class_3532.method_15387((int)k, (int)this.field_4147);
            return sections[this.getChunkIndex(i, j, k)];
        }
        return null;
    }

    @Nullable
    protected class_846.class_851 method_3323(class_2338 pos) {
        int i = class_3532.method_48116((int)pos.method_10263(), (int)16);
        int j = class_3532.method_48116((int)(pos.method_10264() - McHelper.getMinY((class_1936)this.field_4151)), (int)16);
        int k = class_3532.method_48116((int)pos.method_10260(), (int)16);
        if (j >= 0 && j < this.field_4149) {
            int sectionIndex = this.getChunkIndex(i = class_3532.method_15387((int)i, (int)this.field_4148), j, k = class_3532.method_15387((int)k, (int)this.field_4147));
            class_846.class_851 result = this.field_4150[sectionIndex];
            if (result == null) {
                Helper.err("Null RenderChunk " + String.valueOf(pos));
                return null;
            }
            ((IERenderSection)result).portal_setIndex(sectionIndex);
            return result;
        }
        return null;
    }

    @Nullable
    public class_846.class_851 rawFetch(int cx, int cy, int cz, long timeMark) {
        if (cy < this.minSectionY || cy >= this.endSectionY) {
            return null;
        }
        long l = class_1923.method_8331((int)cx, (int)cz);
        Column column = this.provideColumn(l);
        column.mark = timeMark;
        int yOffset = cy - this.minSectionY;
        return column.sections[yOffset];
    }

    @Nullable
    public class_846.class_851 rawGet(int cx, int cy, int cz) {
        if (cy < this.minSectionY || cy >= this.endSectionY) {
            return null;
        }
        long l = class_1923.method_8331((int)cx, (int)cz);
        Column column = (Column)this.columnMap.get(l);
        if (column == null) {
            return null;
        }
        int yOffset = cy - this.minSectionY;
        return column.sections[yOffset];
    }

    public static class Preset {
        public final class_846.class_851[] data;
        public long lastActiveTime = 0L;

        public Preset(class_846.class_851[] data) {
            this.data = data;
        }
    }

    public static class Column {
        public long mark = 0L;
        public class_846.class_851[] sections;

        public Column(class_846.class_851[] sections) {
            this.sections = sections;
        }
    }
}

